﻿using System;
using System.Net;
using System.Collections.Generic;
using System.Collections;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Media.Imaging;

namespace GraphicChart.Core
{

    /// <summary>
    /// Trieda, pomocou ktorej sa vykresluje Grid, napriklad pr Column Chart, Line Chart,... 
    /// Vykresluju sa tu X, Y osi, rozdeluju sa tu deliace ciary, popisky
    /// </summary>
    public class GridDraw
    {

        protected Canvas c;                                   // kanvas pre vykreslovanie grafov
        protected Grid g;                                     // kanvas pre vykreslovanie grafov
        protected Core.ChartVariables cv;                     // vsetky premenne grafu
        protected GlobalVariables gv;                         // vseobcne premenne grafov
        protected List<string> sort;                          // tu je ulozeny list stringov pre selekciu ak sa sortovalo "1a" graf 1 ascending
        protected List<List<string>> data;                    // vsetky data pokope este
        protected List<string> dataX;                         // data pre Xovu os
        protected List<double> dataY;                         // data pre Yovu os
        protected double maxValueFromDataY;                   // najvyzsia hodnota z datoveho zdroja
        protected double numberOfYAxis;                       // pomocna premenna v ktorej sa uchovava pocet segmentov pozri pomocny papier "X1"
        protected int segmentWidth;                           // sirka segmentu (columnu)
        protected double tempForY;                            // pomocna premenna do ktorej si ukladam vysku najvyzsej vodorovnej ciary
        protected List<string> selectedValues;                // prida do bola hodnoty ktore sa maju selektovat     
        protected IEnumerable<Core.ChartVariables> ess;       // vsetky premenne pre vsetky grafy
        protected Calendar calendarChart;                     // kalendar
        protected Point point;                                // sem sa uklada bod pre ScaleBreak ak sa kliklo
       
        protected int segDown;                                // pocet segmentov (medzi 2 Y ciarami) ktore moze byt vyhodene pod klikom ScaleBreaku
        protected double segDownMax;                          // maximalna najblizsia velkost segmentu pod ciarov ScaleBreak
        protected double segUpMin;                            // najblizsia velkost segmentu nad ciarou;
        protected int SegDownAll;                             // pocet vsetkych segemntov pod ciarov

        public GridDraw()
        {
        }

        public GridDraw(List<string> sort1, List<string> s1, Grid g1, Canvas c1, Core.ChartVariables cv1, List<string> dataX1, List<double> dataY1, List<List<string>> data1, IEnumerable<Core.ChartVariables> es1)
        {
            g = g1;
            c = c1;
            cv = cv1;
            ess = es1;
            selectedValues = s1;
            data = data1;
            dataX = dataX1;
            dataY = dataY1;
            sort = sort1;
            gv = new GlobalVariables();
            segDown = 0;
            segDownMax = 20000;
            segUpMin = 20000;
            SegDownAll = 0;

            // co sa ma stat ked sa hybe mys, presnejsie sa ma vykrelsovat ScaleBreakCiara, teda iba ak je zpanuty
            if(cv.ScaleBreaks == true) c.MouseMove += new MouseEventHandler(ScaleBreakHover);
            

            // do premennej vypocita sirku stlpca podla poctu zaznamov a podla toho urict sirku stlpca
            segmentWidth = 0;
            if (dataX.Count > 0) segmentWidth = (cv.ChartWidth - 90) / dataX.Count;

            // ak su nejake udaje na zobrazenie tka vykresli graf, inac iba vykresli mriezku
            // pripadne ak je sirka segmentu mensia ako MinColumnWidth tak ozbrazi spravu prilis vela udajov
            if (dataX.Count > 0 & dataX != null && segmentWidth > gv.MinColumnWidth)
            {
                // inicializacia a najdene najvacsej hodnoty
                maxValueFromDataY = 1;
                for (int i = 0; i < dataY.Count; i++)
                {
                    if (dataY[i] > maxValueFromDataY)
                    {
                        // ak je najvyzsia hodnota v selektovanych hodnotach tak sa nabude brat v uvahu
                        if (!selectedValues.Contains(dataX[i]))
                        {
                            maxValueFromDataY = dataY[i];
                        }
                    }
                }

                if (segmentWidth > gv.MaxColumnWidth) segmentWidth = gv.MaxColumnWidth;
                if (segmentWidth < gv.MinColumnWidth) segmentWidth = gv.MinColumnWidth;

                numberOfYAxis = (cv.ChartHeight - (double)100) / (double)gv.LneDistance;    // vyratava pocet rorizontalnych ciar

                CountSegDownAndSegUp();     // vypocita pocty segmentov, ktore sa mozu vyhodit
                DrawLineSegments();         // Vykresli Y sustredne ciary s popiskami
                DrawXAxis();                // vykreslenie suradnicovej osi X
                DrawYAxis();                // vykreslenie suradnicovej osi Y
                DrawXAxisLegend();          // Vykresli popisky k X ciare
                DrawLineLegend();           // Vykresli popisky k sustrednym Y ciaram
                DrawGrafSegments();         // Vykresli na platno stlpce grafov
                DrawTittle();               // Vykresli popisok grafu
                DrawSortButtons();          // Vykresli buttony na sortovanie
                DrawScaleBreaksButton();    // Vykresli button pre ScaleBreaks
                DrawScaleBreak();           // Vykresli ScaleBreak;
                DrawAlternativeButtons();   // Buttony pre alternativny graf, konretne zlucovanie stlpcov
                if (cv.IsXDataDateTime == true && Convert.ToInt32(cv.DateTimeSource) >= 0)
                {
                    DrawGranularityButtons();   // Vykresli buttony granularity
                }
            }
            else {
                numberOfYAxis = (cv.ChartHeight - (double)100) / (double)gv.LneDistance;    // vyratava pocet rorizontalnych ciar
    
                DrawLineSegments();         // Vykresli Y sustredne ciary s popiskami
                DrawXAxis();                // vykreslenie suradnicovej osi X
                DrawYAxis();                // vykreslenie suradnicovej osi Y
                DrawTittle();               // Vykresli popisok grafu

                if (segmentWidth < gv.MinColumnWidth && segmentWidth != 0) DrawTooManyData();
            }
        }


        /// <summary>
        /// Vypocita pocty segmentov, ktore sa mozu vyhodit dalsie pomocne premenne pre ScaleBreak
        /// </summary>
        public void CountSegDownAndSegUp()
        {
            double i = 0;
            double max = 20000;
            double min = 0;
            int k = 0;
            foreach (double j in dataY)
            {
                i = cv.ChartHeight - 45 - (((numberOfYAxis - 1) * gv.LneDistance) / maxValueFromDataY) * j;
                if (i < max && i > cv.SaleBreaksClick.Y && !selectedValues.Contains(dataX[k]))
                {
                    max = i;
                    segDownMax = j;
                }
                
                // najde nad ciarou najblizsi segment 
                if (i > min && i < cv.SaleBreaksClick.Y && !selectedValues.Contains(dataX[k]))
                {
                    min = i;
                    segUpMin = j;
                }

                k++;
            }
            if (cv.SaleBreaksClick.Y != (double)0 && max != 20000) {
                segDown = (int)((max - min) / gv.LneDistance);
                SegDownAll = (int)((cv.ChartHeight - min - 45) / gv.LneDistance);
            }
        }


        /// <summary>
        /// Vykresli na platno X ovu suradnicou siet
        /// </summary>
        public void DrawXAxis()
        {
            Line line1 = new Line();
            line1.X1 = 45;
            line1.Y1 = cv.ChartHeight - 45;
            line1.X2 = cv.ChartWidth - 45;
            line1.Y2 = cv.ChartHeight - 45;
            line1.Stroke = new SolidColorBrush(Color.FromArgb(255, 207, 207, 207));
            line1.StrokeThickness = 1;
            line1.RenderTransform = new TranslateTransform() { X = 0.5, Y = 0.5 };

            c.Children.Add(line1);
        }


        /// <summary>
        /// Vykresli na platno Y ovu suradnicou siet
        /// </summary>
        public void DrawYAxis()
        {
            Line line1 = new Line();
            line1.X1 = 50;
            line1.Y1 = tempForY - 5;
            line1.X2 = 50;
            line1.Y2 = cv.ChartHeight - 40;
            line1.Stroke = new SolidColorBrush(Color.FromArgb(255, 207, 207, 207));
            line1.StrokeThickness = 1;
            line1.RenderTransform = new TranslateTransform() { X = 0.5, Y = 0.5 };

            c.Children.Add(line1);
        }


        /// <summary>
        /// Vykresli popisky k X ciare
        /// </summary>
        public void DrawXAxisLegend()
        {
            // tu si nastavi ci potrebuje popisky dat sikmo
            bool needRotate = false;
            foreach (string i in dataX)
            {
                if (segmentWidth / i.Length < 7) needRotate = true;
            }

            for (int i = 0; i < dataX.Count; i++)
            {
                // vykreslenie hornych popiskov 
                TextBlock textBlock1 = new TextBlock();
                textBlock1.Text = dataX[i];
                textBlock1.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 40));
                textBlock1.SetValue(Canvas.LeftProperty, Convert.ToDouble(55 + i * segmentWidth + (segmentWidth - textBlock1.ActualWidth) / 2));
                textBlock1.HorizontalAlignment = HorizontalAlignment.Center;
                textBlock1.TextAlignment = TextAlignment.Center;
                textBlock1.FontSize = Convert.ToDouble(9);
                if (needRotate == true)
                {
                    textBlock1.SetValue(Canvas.LeftProperty, Convert.ToDouble(55 + i * segmentWidth + (segmentWidth - textBlock1.ActualWidth) / 2));
                    textBlock1.RenderTransform = new RotateTransform() { Angle = 24 };
                }
                c.Children.Add(textBlock1);
            }

        }


        /// <summary>
        /// Vykresli na platno vodorovne ciary
        /// </summary>
        public void DrawLineSegments()
        {
            // vykreslenie ciar
            for (int i = 1; i <= Convert.ToInt32(numberOfYAxis); i++)
            {
                Line line1 = new Line();
                line1.X1 = 45;
                line1.Y1 = cv.ChartHeight - 45 - gv.LneDistance * i;
                line1.X2 = cv.ChartWidth - 50;
                line1.Y2 = cv.ChartHeight - 45 - gv.LneDistance * i;
                line1.Stroke = new SolidColorBrush(Color.FromArgb(255, 239, 239, 239));
                line1.StrokeThickness = 1;
                line1.RenderTransform = new TranslateTransform() { X = 0.5, Y = 0.5 };
                c.Children.Add(line1);
                tempForY = line1.Y1;
            }
        }


        /// <summary>
        /// Vykreslenie popiskov k Y ciaram
        /// </summary>
        public void DrawLineLegend()
        {
            // vykreslenie popiskov
            for (int i = 0; i <= Convert.ToInt32(numberOfYAxis); i++)
            {
                double tmp = 0;
                tmp = maxValueFromDataY / (numberOfYAxis - 1);

                TextBlock textBlock1 = new TextBlock();
                textBlock1.Text = Convert.ToString(Math.Round(tmp * i, 2));
                textBlock1.Width = 40;
                textBlock1.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 45 - gv.LneDistance * i - 6));
                textBlock1.SetValue(Canvas.LeftProperty, Convert.ToDouble(0));
                if (cv.ScaleBreaks == true && i < (SegDownAll))
                {
                    if (i <= SegDownAll && segDown >= 2)
                    {
                        tmp = segDownMax / (SegDownAll - 1);
                        textBlock1.Text = Convert.ToString(Math.Round(tmp * i, 2));
                    }
                }
                textBlock1.TextAlignment = TextAlignment.Right;
                textBlock1.FontSize = Convert.ToDouble(8);  
                c.Children.Add(textBlock1);
            }
        }



        /// <summary>
        /// Vykresli na platno stlpce grafov
        /// </summary>
        public void DrawGrafSegments()
        {
            Canvas cTmp = new Canvas();

            int j = -1;
            foreach (double i in dataY)
            {
                j += 1;
                // vykreslenie stlpcov grafov
                Rectangle rect1 = new Rectangle();
                rect1.Tag = dataX[j];
                rect1.Width = segmentWidth - 10;
                rect1.Height = (((numberOfYAxis - 1) * gv.LneDistance) / maxValueFromDataY) * i;
                rect1.Fill = new SolidColorBrush(gv.chartColor[j % 10]);
                if (selectedValues.Contains(dataX[j]))
                {
                    rect1.Height = (((numberOfYAxis - 1) * gv.LneDistance) / maxValueFromDataY) * maxValueFromDataY;
                    rect1.Fill = new SolidColorBrush(Color.FromArgb(2, 0, 0, 0));
                }
                rect1.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 45 - rect1.Height));
                rect1.SetValue(Canvas.LeftProperty, Convert.ToDouble(55 + j * segmentWidth));
                // Rozlisuje Eventy podla toho ci je zpapnuty ScalBreak, alebo nie
                if (cv.ScaleBreaks == false)
                {
                    rect1.MouseLeftButtonDown += new MouseButtonEventHandler(SegmentSelection);
                    rect1.MouseEnter += new MouseEventHandler(SegmentHover);
                    rect1.MouseLeave += new MouseEventHandler(SegmentLeave);
                    rect1.Cursor = Cursors.Hand;
                }
                else if(!selectedValues.Contains(dataX[j]))
                {
                    rect1.MouseLeftButtonDown += new MouseButtonEventHandler(ScaleBreakSelection);
                    rect1.Cursor = Cursors.Hand;
                    if (i <= segDownMax && segDown >= 2)
                    {
                        rect1.Height = (((SegDownAll - 1) * gv.LneDistance) / segDownMax) * i;
                        if (i == 0)
                        {
                            rect1.Height = 0;
                        }
                        rect1.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 45 - rect1.Height));
                    }
                    
                }
                

                // vykreslenie hornych popiskov 
                TextBlock textBlock1 = new TextBlock();
                textBlock1.Text = Convert.ToString(i);
                textBlock1.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - rect1.Height - 57));
                textBlock1.SetValue(Canvas.LeftProperty, Convert.ToDouble(55 + j * segmentWidth + (segmentWidth - textBlock1.ActualWidth) / 2));
                textBlock1.HorizontalAlignment = HorizontalAlignment.Center;
                textBlock1.FontSize = Convert.ToDouble(8);
                textBlock1.Foreground = new SolidColorBrush(Color.FromArgb(155, 175, 175, 175));

                cTmp.Children.Add(rect1);
                cTmp.Children.Add(textBlock1);

                if (selectedValues.Contains(dataX[j]))
                {
                    textBlock1.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 59));
                    textBlock1.Foreground = new SolidColorBrush(Color.FromArgb(155, 255, 143, 143));
                }
            }

            c.Children.Add(cTmp);
        }


        /// <summary>
        /// Vykresli popisok grafu
        /// </summary>
        public void DrawTittle()
        {
            if (cv.ShowDescription)
            {
                TextBlock textBlock1 = new TextBlock();
                textBlock1.Width = cv.ChartWidth - 100;
                textBlock1.Text = cv.ChartHeading;
                textBlock1.SetValue(Canvas.TopProperty, Convert.ToDouble(10));
                textBlock1.SetValue(Canvas.LeftProperty, Convert.ToDouble(60));
                textBlock1.TextAlignment = TextAlignment.Center;
                textBlock1.FontSize = Convert.ToDouble(12);
                c.Children.Add(textBlock1);
            }
        }

        public void DrawTooManyData()
        {
            TextBlock textBlock1 = new TextBlock();
            textBlock1.Width = cv.ChartWidth - 100;
            textBlock1.Text = gv.TooManyData;
            textBlock1.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight / 2));
            textBlock1.SetValue(Canvas.LeftProperty, Convert.ToDouble(60));
            textBlock1.TextAlignment = TextAlignment.Center;
            textBlock1.FontSize = Convert.ToDouble(12);
            textBlock1.TextAlignment = TextAlignment.Center;
            c.Children.Add(textBlock1);
        }


        /// <summary>
        /// Zobrazi tlaidla na sortovanie grafu
        /// </summary>
        public void DrawSortButtons()
        {
            // button na sortovanie od najmensieho
            Button bA = new Button();
            bA.Width = 12;
            bA.Height = 12;
            bA.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 35));
            bA.SetValue(Canvas.LeftProperty, Convert.ToDouble(15));
            bA.Style = App.Current.Resources["sortAButton"] as Style;
            bA.Cursor = Cursors.Hand;
            c.Children.Add(bA);
            bA.Click += delegate(object sender, RoutedEventArgs e)
            {
                SortAscending(sender, e);
            };

            // button na sortovanie od najvacsieho
            Button bD = new Button();
            bD.Width = 12;
            bD.Height = 12;
            bD.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 35));
            bD.SetValue(Canvas.LeftProperty, Convert.ToDouble(30));
            bD.Style = App.Current.Resources["sortDButton"] as Style;
            bD.Cursor = Cursors.Hand;
            c.Children.Add(bD);
            bD.Click += delegate(object sender, RoutedEventArgs e)
            {
                SortDescending(sender, e);
            };         
        }


        /// <summary>
        /// Zobrazi tlaidlo pre ScaleBreaks
        /// </summary>
        public void DrawScaleBreaksButton()
        {
            Button b = new Button();
            b.Width = 12;
            b.Height = 12;
            b.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 50));
            b.SetValue(Canvas.LeftProperty, Convert.ToDouble(cv.ChartWidth - 40));
            if (cv.ScaleBreaks == true)
            {
                b.Style = App.Current.Resources["scaleBreaksOn"] as Style;
            }
            else
            {
                b.Style = App.Current.Resources["scaleBreaksOff"] as Style;
            }
            b.Cursor = Cursors.Hand;
            c.Children.Add(b);
            b.Click += delegate(object sender, RoutedEventArgs e)
            {
                ScaleBreaksTurnOnOff(sender, e);
            };
        }
        

        /// <summary>
        /// Vykresli ScaleBreak
        /// </summary>
        public void DrawScaleBreak()
        {
            if (cv.SaleBreaksClick != new Point() && segDown >= 2)
            {
                Rectangle lineScaleBreak = new Rectangle();
                lineScaleBreak.Width = cv.ChartWidth - 20;
                lineScaleBreak.Height = 4;
                lineScaleBreak.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 45 - ((SegDownAll - 1) * gv.LneDistance) - 16));
                lineScaleBreak.SetValue(Canvas.LeftProperty, Convert.ToDouble(10));
                ImageBrush ib = new ImageBrush();
                ib.ImageSource = new BitmapImage(new Uri("Images/scale-break-bg.png", UriKind.RelativeOrAbsolute));
                lineScaleBreak.Fill = ib;
                c.Children.Add(lineScaleBreak);
            }
            if (segDown < 2)
            {
                cv.SaleBreaksClick = new Point();
            }
        }


        /// <summary>
        /// Vynuluje hodnotu bodu pre ScaleBreaks
        /// </summary>
        public void ClearScalBreaksPoint()
        {
            List<Core.ChartVariables> lTemp = new List<Core.ChartVariables>();
            foreach (ChartVariables cvTemp in ess)
            {
                if (cvTemp.ID == cv.ID)
                {
                    cvTemp.SaleBreaksClick = new Point();
                }
                lTemp.Add(cvTemp);
            }
            ess = lTemp;
        }


        /// <summary>
        /// Zobrazi tlaidla na zlucenie dat
        /// </summary>
        public void DrawAlternativeButtons()
        {
            if (Convert.ToInt32(cv.AlternativeChartFirst) >= 0 && cv.IsXDataDateTime != true)
            {
                Button bA = new Button();
                bA.Width = 12;
                bA.Height = 12;
                bA.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 20));
                bA.SetValue(Canvas.LeftProperty, Convert.ToDouble(15));
                bA.Style = App.Current.Resources["alternativeFirstButton"] as Style;
                bA.Cursor = Cursors.Hand;
                c.Children.Add(bA);
                bA.Click += delegate(object sender, RoutedEventArgs e)
                {
                    AlternativeFirst(sender, e);
                };
            }

            if (Convert.ToInt32(cv.AlternativeChartSecond) >= 0 && cv.IsXDataDateTime != true)
            {
                Button bD = new Button();
                bD.Width = 12;
                bD.Height = 12;
                bD.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 20));
                bD.SetValue(Canvas.LeftProperty, Convert.ToDouble(30));
                bD.Style = App.Current.Resources["alternativeSecondButton"] as Style;
                bD.Cursor = Cursors.Hand;
                c.Children.Add(bD);
                bD.Click += delegate(object sender, RoutedEventArgs e)
                {
                    AlternativeSecond(sender, e);
                };
            }
        }




        /// <summary>
        /// Zobrazi tlaidla na granularitu
        /// </summary>
        public void DrawGranularityButtons()
        {
            Button b1 = new Button();
            b1.Width = 12;
            b1.Height = 12;
            b1.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 35));
            b1.SetValue(Canvas.LeftProperty, Convert.ToDouble(cv.ChartWidth - 40));
            b1.Style = App.Current.Resources["granularityMonthButton"] as Style;
            b1.Cursor = Cursors.Hand;
            c.Children.Add(b1);
            b1.Click += delegate(object sender, RoutedEventArgs e)
            {
                GranularityMonth(sender, e);
            };

            Button b2 = new Button();
            b2.Width = 12;
            b2.Height = 12;
            b2.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 35));
            b2.SetValue(Canvas.LeftProperty, Convert.ToDouble(cv.ChartWidth - 25));
            b2.Style = App.Current.Resources["granularityTermButton"] as Style;
            b2.Cursor = Cursors.Hand;
            c.Children.Add(b2);
            b2.Click += delegate(object sender, RoutedEventArgs e)
            {
                GranularityTerm(sender, e);
            };

            Button b3 = new Button();
            b3.Width = 12;
            b3.Height = 12;
            b3.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 20));
            b3.SetValue(Canvas.LeftProperty, Convert.ToDouble(cv.ChartWidth - 40));
            b3.Style = App.Current.Resources["granularityHalfYearButton"] as Style;
            b3.Cursor = Cursors.Hand;
            c.Children.Add(b3);
            b3.Click += delegate(object sender, RoutedEventArgs e)
            {
                GranularityHalfYear(sender, e);
            };

            Button b4 = new Button();
            b4.Width = 12;
            b4.Height = 12;
            b4.SetValue(Canvas.TopProperty, Convert.ToDouble(cv.ChartHeight - 20));
            b4.SetValue(Canvas.LeftProperty, Convert.ToDouble(cv.ChartWidth - 25));
            b4.Style = App.Current.Resources["granularityYearButton"] as Style;
            b4.Cursor = Cursors.Hand;
            c.Children.Add(b4);
            b4.Click += delegate(object sender, RoutedEventArgs e)
            {
                GranularityYear(sender, e);
            };
        }


        /// <summary>
        /// Po kliknuti sa stlpec vyselektuje z vysledkov
        /// </summary>
        void SegmentSelection(object sender, MouseButtonEventArgs e)
        {            
            Rectangle tb = sender as Rectangle;    

            g.Children.Clear();
            if (selectedValues != null && selectedValues.Contains(tb.Tag.ToString())) { selectedValues.Remove(tb.Tag.ToString()); }
            else { selectedValues.Add(tb.Tag.ToString()); }

            // vytvorenie lokalnych premennych pre kazdy graf nacitanim dat z XML a inicializovanie grafov
            Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, ess, cv.Granularity, cv.AlternativeList);
        }


        /// <summary>
        /// Po kliknuti sa stlpec sa zaznamena scale break a vykresli sa
        /// </summary>
        void ScaleBreakSelection(object sender, MouseButtonEventArgs e)
        {
            IEnumerable<Core.ChartVariables> essTemp;
            List<Core.ChartVariables> lTemp = new List<Core.ChartVariables>();

            g.Children.Clear();
            foreach (ChartVariables cvTemp in ess)
            {
                if (cvTemp.ID == cv.ID)
                {
                    if (cv.SaleBreaksClick == new Point())
                    {
                        cvTemp.SaleBreaksClick = point;
                    }
                    else
                    {
                        cvTemp.SaleBreaksClick = new Point();
                    }
                }
                lTemp.Add(cvTemp);
            }
            essTemp = lTemp;
            Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, essTemp, cv.Granularity, cv.AlternativeList);
        }


        /// <summary>
        /// Co nastane po prejdeni mysou cez segment grafu
        /// </summary>
        void ScaleBreakHover(object sender, MouseEventArgs e)
        {
            point = e.GetPosition(c);
            //ak sa pohybuje kurzorom niekde v grafe
            if (point.X > 10 && point.X < cv.ChartWidth - 10 && point.Y > tempForY - 5 && point.Y < cv.ChartHeight - 50)
            {
                if (c.FindName("scaleBreak") == null)
                {
                    Line lineScaleBreak = new Line();
                    lineScaleBreak.Name = "scaleBreak";
                    lineScaleBreak.X1 = 10;
                    lineScaleBreak.Y1 = point.Y + 3;
                    lineScaleBreak.X2 = cv.ChartWidth - 10;
                    lineScaleBreak.Y2 = point.Y + 3;
                    lineScaleBreak.Stroke = new SolidColorBrush(Color.FromArgb(255, 255, 0, 0));
                    lineScaleBreak.StrokeThickness = 1;
                    c.Children.Add(lineScaleBreak);
                }
                else
                {
                    Line lineScaleBreak = (Line)c.FindName("scaleBreak");
                    lineScaleBreak.Y1 = point.Y + 3;
                    lineScaleBreak.Y2 = point.Y + 3;
                }
            }
            else
            {
                Line lineScaleBreak = (Line)c.FindName("scaleBreak");
                c.Children.Remove(lineScaleBreak);
            }
        }


        /// <summary>
        /// Co nastane po prejdeni mysou cez segment grafu
        /// </summary>
        void SegmentHover(object sender, MouseEventArgs e)
        {
            Rectangle tb = sender as Rectangle;
            tb.Opacity = 0.7;
        }


        /// <summary>
        /// Co nastane po ak mys sa vrati zo segmentu
        /// </summary>
        void SegmentLeave(object sender, MouseEventArgs e)
        {
            Rectangle tb = sender as Rectangle;
            tb.Opacity = 1;
        }


        /// <summary>
        /// Zoradi vzostupne
        /// </summary>
        public void SortAscending(object sender, RoutedEventArgs e)
        {
            string sTmp = cv.ID.ToString() + "a";
            sort.Remove(cv.ID.ToString() + "d");

            if (sort.IndexOf(sTmp) >= 0) {
                g.Children.Clear();
                sort.Remove(sTmp);
                ClearScalBreaksPoint();
                Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, ess, cv.Granularity, cv.AlternativeList); ;            
            } else
            {
                g.Children.Clear();
                sort.Add(sTmp);
                ClearScalBreaksPoint();
                Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, ess, cv.Granularity, cv.AlternativeList);
            }
        }


        /// <summary>
        /// Zoradi zostupne
        /// </summary>
        public void SortDescending(object sender, RoutedEventArgs e)
        {
            string sTmp = cv.ID.ToString() + "d";
            sort.Remove(cv.ID.ToString() + "a");

            if (sort.IndexOf(sTmp) >= 0) {
                g.Children.Clear();
                sort.Remove(sTmp);
                ClearScalBreaksPoint();
                Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, ess, cv.Granularity, cv.AlternativeList);           
            }
            else
            {
                g.Children.Clear();
                sort.Add(sTmp);
                ClearScalBreaksPoint();
                Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, ess, cv.Granularity, cv.AlternativeList);
            }
        }


        /// <summary>
        /// Prepne ScaleBreaks
        /// </summary>
        public void ScaleBreaksTurnOnOff(object sender, RoutedEventArgs e)
        {
            IEnumerable<Core.ChartVariables> essTemp;
            List<Core.ChartVariables> lTemp = new List<Core.ChartVariables>();


            g.Children.Clear();
            if (cv.ScaleBreaks == true)
            {
                cv.ScaleBreaks = false;
                cv.SaleBreaksClick = new Point();
            }
            else 
            {
                cv.ScaleBreaks = true;
            }
            foreach (ChartVariables cvTemp in ess)
            {
                if (cvTemp.ID == cv.ID)
                {
                    cvTemp.ScaleBreaks = cv.ScaleBreaks;
                }
                lTemp.Add(cvTemp);
            }
            essTemp = lTemp;
            Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, essTemp, cv.Granularity, cv.AlternativeList);
        }


        /// <summary>
        /// Alternativny grafy, (zlucenie)
        /// </summary>
        public void AlternativeFirst(object sender, RoutedEventArgs e)
        {
            g.Children.Clear();
            string s4 = cv.XData + ":" + cv.AlternativeChartFirst;
            selectedValues = new List<string>();
            sort = new List<string>();
            if (cv.AlternativeList.Contains(s4)){ cv.AlternativeList.Remove(s4); }else{ cv.AlternativeList.Add(s4); }
            ClearScalBreaksPoint();
            Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, ess, cv.Granularity, cv.AlternativeList);
        }
        public void AlternativeSecond(object sender, RoutedEventArgs e)
        {
            g.Children.Clear();
            string s4 = cv.XData + ":" + cv.AlternativeChartSecond;
            selectedValues = new List<string>();
            sort = new List<string>();
            if (cv.AlternativeList.Contains(s4)) { cv.AlternativeList.Remove(s4); } else { cv.AlternativeList.Add(s4); }
            ClearScalBreaksPoint();
            Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, ess, cv.Granularity, cv.AlternativeList);
        }
        

        /// <summary>
        /// Spracovanie granularity
        /// </summary>
        public void GranularityMonth(object sender, RoutedEventArgs e)
        {
            g.Children.Clear();
            selectedValues = new List<string>();
            sort = new List<string>();
            ClearScalBreaksPoint();
            Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, ess, "month", cv.AlternativeList);
        }
        public void GranularityTerm(object sender, RoutedEventArgs e)
        {
            g.Children.Clear();
            selectedValues = new List<string>();
            sort = new List<string>();
            ClearScalBreaksPoint();
            Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, ess, "term", cv.AlternativeList);
        }
        public void GranularityHalfYear(object sender, RoutedEventArgs e)
        {
            g.Children.Clear();
            selectedValues = new List<string>();
            sort = new List<string>();
            ClearScalBreaksPoint();
            Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, ess, "half-year", cv.AlternativeList);
        }
        public void GranularityYear(object sender, RoutedEventArgs e)
        {
            g.Children.Clear();
            selectedValues = new List<string>();
            sort = new List<string>();
            ClearScalBreaksPoint();
            Core.XmlParsing xmlParsing = new Core.XmlParsing(g, selectedValues, sort, data, ess, "year", cv.AlternativeList);
        }

    }
}
